// Service Worker for PDF2Kindle Extension
importScripts('config.js');

chrome.runtime.onInstalled.addListener(() => {
    console.log('PDF2Kindle extension installed');
});

// Listen for messages from popup
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if (request.action === 'sendToKindle') {
        handleSendToKindle(request.url, request.title, request.kindleEmail)
            .then(result => sendResponse({ success: true, result }))
            .catch(error => sendResponse({ success: false, error: error.message }));

        // Return true to indicate async response
        return true;
    }
});

async function handleSendToKindle(url, title, kindleEmail) {
    console.log('Sending PDF to Kindle:', { url, title, kindleEmail });

    const res = await fetch(`${CONFIG.API_BASE_URL}/api/send-kindle`, {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify({ pdf_url: url, fname: title, kindle_email: kindleEmail })
    });

    let body;
    try {
        body = await res.json();
    } catch (error) {
        throw new Error('Failed to parse response from Kindle service');
    }

    if (!res.ok) {
        throw new Error(body?.message || 'Failed to send PDF to Kindle');
    }
    return body;
}
